<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwdatetime="urn:WebWorks-Date-Time-Extension"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwvars wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc wwdatetime"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterStylesType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterTOCDataType" />
 <xsl:param name="ParameterAllowBaggage" />
 <xsl:param name="ParameterAllowGroupToGroup" />
 <xsl:param name="ParameterAllowURL" />
 <xsl:param name="ParameterBaggageSplitFileType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterDocumentPDFType" />
 <xsl:param name="ParameterGroupPDFType" />


 <xsl:variable name="GlobalDefaultNamespace" select="'http://www.w3.org/1999/xhtml'" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:include href="wwtransform:common/accessibility/images.xsl"/>
 <xsl:include href="wwtransform:common/accessibility/tables.xsl"/>
 <xsl:include href="wwtransform:common/behaviors/options.xsl"/>
 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:common/images/utilities.xsl" />
 <xsl:include href="wwtransform:common/links/resolve.xsl" />
 <xsl:include href="wwtransform:common/pages/pages.xsl" />
 <xsl:include href="wwtransform:common/project/conditions.xsl" />
 <xsl:include href="wwtransform:common/project/properties.xsl" />
 <xsl:include href="wwtransform:common/tables/tables.xsl" />
 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:html/css_properties.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />
 <xsl:include href="wwformat:Transforms/connect_utilities.xsl" />
 <xsl:include href="wwformat:Transforms/content.xsl" />
 <!-- Publication Date. -Lief 3. May 2011 -->
 <xsl:include href="wwformat:Transforms/datetime.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/accessibility/images.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/accessibility/images.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/accessibility/tables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/accessibility/tables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/behaviors/options.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/behaviors/options.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/images/utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/images/utilities.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/links/resolve.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/links/resolve.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pages.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pages.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/project/conditions.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/project/conditions.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/project/properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/project/properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/tables/tables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/tables/tables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:html/css_properties.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:html/css_properties.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/connect_utilities.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/content.xsl')))" />
   <!-- Publication Date. -Lief 3. May 2011 -->
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwformat:Transforms/datetime.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwformat:Transforms/datetime.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Page template include files -->
 <!--                             -->
 <xsl:variable name="GlobalPageTemplateIncludeFilesAsXML">
  <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-include-files">
   <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
  </xsl:apply-templates>
 </xsl:variable>
 <xsl:variable name="GlobalPageTemplateIncludeFiles" select="msxsl:node-set($GlobalPageTemplateIncludeFilesAsXML)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <!-- Connect Pages -->
 <!--               -->
 <xsl:variable name="GlobalEntryPagePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetFormatSetting('connect-entry'))" />
 <xsl:variable name="GlobalSearchPagePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'connect', 'search.html')" />


 <xsl:variable name="GlobalFilenameSpacesToUnderscores" select="wwprojext:GetFormatSetting('filename-spaces-to-underscores') = 'true'" />
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresSearchString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text> </xsl:text>
  </xsl:if>
 </xsl:variable>
 <xsl:variable name="GlobalFilenameSpacesToUnderscoresReplaceString">
  <xsl:if test="$GlobalFilenameSpacesToUnderscores">
   <xsl:text>_</xsl:text>
  </xsl:if>
 </xsl:variable>

 <xsl:variable name="GlobalInvalidPathCharactersExpression" select="'[#&amp;?]'" />

 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <xsl:call-template name="DocumentsPages">
    <xsl:with-param name="ParamInput" select="$GlobalInput" />
    <xsl:with-param name="ParamProject" select="$GlobalProject" />
    <xsl:with-param name="ParamFiles" select="$GlobalFiles" />
    <xsl:with-param name="ParamLinksType" select="$ParameterLinksType" />
    <xsl:with-param name="ParamDependsType" select="$ParameterDependsType" />
    <xsl:with-param name="ParamSplitsType" select="$ParameterSplitsType" />
    <xsl:with-param name="ParamBehaviorsType" select="$ParameterBehaviorsType" />
    <xsl:with-param name="ParamTOCDataType" select="$ParameterTOCDataType" />
   </xsl:call-template>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Page">
  <xsl:param name="ParamFilesSplits" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamBehaviorsFile" />
  <xsl:param name="ParamBehaviors" />
  <xsl:param name="ParamLinks" />
  <xsl:param name="ParamTOCData" />
  <xsl:param name="ParamBreadcrumbTOCEntry" />
  <xsl:param name="ParamFilesDocumentNode" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamDocument" />
  <xsl:param name="ParamContent" />

  <!-- Output -->
  <!--        -->
  <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($ParamSplit/@path, $GlobalProject/wwproject:Project/@ChangeID, $ParamSplit/@groupID, $ParamSplit/@documentID, $GlobalActionChecksum)" />
  <xsl:if test="not($VarUpToDate)">
   <xsl:variable name="VarResultAsXML">
    <!-- Output directory path -->
    <!--                       -->
    <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwstring:ReplaceWithExpression(wwstring:Replace(wwprojext:GetGroupName($ParamSplit/@groupID), $GlobalFilenameSpacesToUnderscoresSearchString, $GlobalFilenameSpacesToUnderscoresReplaceString), $GlobalInvalidPathCharactersExpression, '_'))" />

    <!-- Page Rule -->
    <!--           -->
    <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', $ParamSplit/@stylename)" />

    <!-- Breadcrumbs -->
    <!--             -->
    <xsl:variable name="VarBreadcrumbsAsXML">
     <xsl:variable name="VarBreadcrumbsGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'breadcrumbs-generate']/@Value" />
     <xsl:if test="($VarBreadcrumbsGenerateOption = 'true') or (string-length($VarBreadcrumbsGenerateOption) = 0)">
      <xsl:call-template name="Breadcrumbs">
       <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
       <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       <xsl:with-param name="ParamBreadcrumbTOCEntry" select="$ParamBreadcrumbTOCEntry" />
      </xsl:call-template>
     </xsl:if>
    </xsl:variable>
    <xsl:variable name="VarBreadcrumbs" select="msxsl:node-set($VarBreadcrumbsAsXML)" />

    <!-- Split files -->
    <!--             -->
    <xsl:for-each select="$ParamSplits[1]">
     <!-- Previous -->
     <!--          -->
     <xsl:variable name="VarPreviousSplit" select="$ParamSplit/preceding-sibling::wwsplits:Split[1]" />

     <!-- Next -->
     <!--      -->
     <xsl:variable name="VarNextSplit" select="$ParamSplit/following-sibling::wwsplits:Split[1]" />

     <!-- Skip Navigation Link -->
     <!--                      -->
     <xsl:variable name="VarSkipNavigationURI">
      <xsl:if test="wwprojext:GetFormatSetting('accessibility-skip-navigation-link', 'false') = 'true'">
       <xsl:text>#</xsl:text>
       <xsl:value-of select="$ParamSplit/@id" />
      </xsl:if>
     </xsl:variable>

     <!-- PDF Link -->
     <!--          -->
     <xsl:variable name="VarPDFLinkPath">
      <xsl:variable name="VarDocumentPDFPath">
       <xsl:for-each select="$GlobalFiles[1]">
        <xsl:variable name="VarDocumentPDFFile" select="key('wwfiles-files-by-documentid', $ParamFilesDocumentNode/@documentID)[@type = $ParameterDocumentPDFType]" />

        <xsl:for-each select="$VarDocumentPDFFile[1]">
         <xsl:value-of select="@path" />
        </xsl:for-each>
       </xsl:for-each>
      </xsl:variable>

      <xsl:variable name="VarGroupPDFPath">
       <xsl:for-each select="$GlobalFiles[1]">
        <xsl:variable name="VarGroupPDFFile" select="key('wwfiles-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterGroupPDFType))" />

        <xsl:for-each select="$VarGroupPDFFile[1]">
         <xsl:value-of select="@path" />
        </xsl:for-each>
       </xsl:for-each>
      </xsl:variable>

      <xsl:choose>
       <xsl:when test="string-length($VarDocumentPDFPath) &gt; 0">
        <xsl:value-of select="$VarDocumentPDFPath" />
       </xsl:when>

       <xsl:when test="string-length($VarGroupPDFPath) &gt; 0">
        <xsl:value-of select="$VarGroupPDFPath" />
       </xsl:when>
      </xsl:choose>
     </xsl:variable>

     <xsl:variable name="VarPDFLinkURI">
      <xsl:if test="string-length($VarPDFLinkPath) &gt; 0">
       <xsl:value-of select="wwuri:GetRelativeTo($VarPDFLinkPath, $ParamSplit/@path)" />
      </xsl:if>
     </xsl:variable>

     <!-- Notes -->
     <!--       -->
     <xsl:variable name="VarNotes" select="$ParamContent//wwdoc:Note[not(ancestor::wwdoc:Table) and not(ancestor::wwdoc:Frame)]" />

     <!-- Note numbering -->
     <!--                -->
     <xsl:variable name="VarNoteNumberingAsXML">
      <xsl:call-template name="Notes-Number">
       <xsl:with-param name="ParamNotes" select="$VarNotes" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarNoteNumbering" select="msxsl:node-set($VarNoteNumberingAsXML)" />

     <!-- Cargo -->
     <!--       -->
     <xsl:variable name="VarCargo" select="$ParamBehaviors | $VarNoteNumbering" />

     <!-- Conditions -->
     <!--            -->
     <xsl:variable name="VarInitialConditionsAsXML">
      <!-- catalog-css -->
      <!--             -->
      <wwpage:Condition name="catalog-css" />

      <!-- document-css -->
      <!--              -->
      <xsl:if test="string-length($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value) &gt; 0">
       <wwpage:Condition name="document-css" />
      </xsl:if>

      <!-- skip-navigation -->
      <!--                 -->
      <xsl:if test="string-length($VarSkipNavigationURI) &gt; 0">
       <wwpage:Condition name="skip-navigation" />
      </xsl:if>

      <!-- button-print -->
      <!--              -->
      <xsl:if test="wwprojext:GetFormatSetting('button-print') = 'true'">
       <wwpage:Condition name="print-enabled" />
      </xsl:if>

      <!-- feedback-email -->
      <!--              -->
      <xsl:if test="string-length(wwprojext:GetFormatSetting('feedback-email')) &gt; 0">
       <wwpage:Condition name="feedback-email" />
      </xsl:if>

      <!-- pdf-exists -->
      <!--            -->
      <xsl:if test="string-length($VarPDFLinkURI) &gt; 0">
       <wwpage:Condition name="pdf-exists" />
      </xsl:if>
      <xsl:if test="string-length($VarPDFLinkURI) = 0">
       <wwpage:Condition name="pdf-not-exists" />
      </xsl:if>

      <!-- breadcrumbs-exist -->
      <!--                   -->
      <xsl:if test="string-length($VarBreadcrumbsAsXML) &gt; 0">
       <wwpage:Condition name="breadcrumbs-exist" />
      </xsl:if>

      <!-- navigation-previous-exists -->
      <!--                            -->
      <xsl:if test="count($VarPreviousSplit) = 1">
       <wwpage:Condition name="navigation-previous-exists" />
      </xsl:if>

      <!-- navigation-next-exists -->
      <!--                        -->
      <xsl:if test="count($VarNextSplit) = 1">
       <wwpage:Condition name="navigation-next-exists" />
      </xsl:if>

      <!-- TOC -->
      <!--     -->
      <xsl:if test="wwprojext:GetFormatSetting('toc-generate') = 'true'"> -->
       <wwpage:Condition name="toc-enabled" />
      </xsl:if> -->

      <!-- Index -->
      <!--       -->
      <xsl:if test="wwprojext:GetFormatSetting('index-generate') = 'true'">
       <wwpage:Condition name="index-enabled" />
      </xsl:if>

      <!-- Search -->
      <!--        -->
      <xsl:if test="wwprojext:GetFormatSetting('google-search') = 'true'">
       <wwpage:Condition name="search-enabled" />
      </xsl:if>

      <!-- Google Translation -->
      <!--                    -->
      <xsl:if test="wwprojext:GetFormatSetting('google-translate') = 'true'">
       <wwpage:Condition name="globe" />
       <wwpage:Condition name="google-translation-enabled" />
      </xsl:if>

      <!-- FaceBook -->
      <!--          -->
      <xsl:if test="wwprojext:GetFormatSetting('social-facebook-like') = 'true'">
       <wwpage:Condition name="facebook-like-enabled" />
      </xsl:if>

      <!-- Twitter -->
      <!--         -->
      <xsl:if test="wwprojext:GetFormatSetting('social-twitter') = 'true'">
       <wwpage:Condition name="twitter-enabled" />
      </xsl:if>

      <!-- Disqus -->
      <!--        -->
      <xsl:if test="string-length(wwprojext:GetFormatSetting('social-disqus-id')) &gt; 0">
       <wwpage:Condition name="disqus-enabled" />
      </xsl:if>

      <!-- Google Analytics -->
      <!--                  -->
      <xsl:if test="string-length(wwprojext:GetFormatSetting('google-analytics-id')) &gt; 0">
       <wwpage:Condition name="google-analytics-enabled" />
      </xsl:if>

      <!-- Company Info -->
      <!--              -->
      <xsl:call-template name="CompanyInfo-Conditions">
       <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarInitialConditions" select="msxsl:node-set($VarInitialConditionsAsXML)" />

     <!-- Set header/footer conditions -->
     <!--                              -->
     <xsl:variable name="VarConditionsAsXML">
      <!-- Copy existing as is -->
      <!--                     -->
      <xsl:for-each select="$VarInitialConditions/*">
       <xsl:copy-of select="." />
      </xsl:for-each>

      <xsl:for-each select="$VarInitialConditions[1]">
       <!-- social-enabled -->
       <!--                -->
       <xsl:if test="count(key('wwpage-conditions-by-name', 'facebook-like-enabled') | key('wwpage-conditions-by-name', 'twitter-enabled')) &gt; 0">
        <wwpage:Condition name="social-enabled" />
       </xsl:if>
      </xsl:for-each>
     </xsl:variable>
     <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

     <!-- Replacements -->
     <!--              -->
     <xsl:variable name="VarReplacementsAsXML">
      <!-- Redirect -->
      <!--          -->
      <xsl:variable name="VarRedirectToEntryURL">
       <xsl:call-template name="Connect-URI-GetRelativeTo">
        <xsl:with-param name="ParamDestinationURI" select="$GlobalEntryPagePath" />
        <xsl:with-param name="ParamSourceURI" select="$ParamSplit/@path" />
       </xsl:call-template>
       <xsl:text>#page/</xsl:text>
       <xsl:value-of select="wwuri:GetRelativeTo($ParamSplit/@path, $GlobalEntryPagePath)" />
      </xsl:variable>
      <wwpage:Replacement name="body-onload">
       <xsl:text>if (window === window.top) { document.location.replace('</xsl:text>
       <xsl:value-of select="$VarRedirectToEntryURL" />
       <xsl:text>'); }</xsl:text>
      </wwpage:Replacement>

      <!-- body-id -->
      <!--         -->
      <xsl:variable name="VarPageIDComponents">
       <xsl:value-of select="$ParamSplit/@groupID" />
       <xsl:text>:</xsl:text>
       <xsl:value-of select="$ParamSplit/@documentID" />
       <xsl:text>:</xsl:text>
       <xsl:value-of select="$ParamSplit/@path" />
      </xsl:variable>
      <xsl:variable name="VarPageID" select="wwstring:NCNAME(translate(wwstring:MD5Checksum($VarPageIDComponents), '=', ''))" />
      <wwpage:Replacement name="body-id" value="p{$VarPageID}" />

      <!-- body-class -->
      <!--            -->
      <wwpage:Replacement name="body-class">
       <xsl:attribute name="value">
        <!-- Skin class -->
        <!--            -->
        <xsl:text>ww_skin_page_body</xsl:text>

        <!-- Additional CSS classes -->
        <!--                        -->
        <xsl:variable name="VarAdditionalCSSClassesOption" select="normalize-space($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'additional-css-classes']/@Value)" />
        <xsl:if test="string-length($VarAdditionalCSSClassesOption) &gt; 0">
         <xsl:text> </xsl:text>
         <xsl:value-of select="$VarAdditionalCSSClassesOption" />
        </xsl:if>
       </xsl:attribute>
      </wwpage:Replacement>

      <!-- body-style -->
      <!--            -->
      <wwpage:Replacement name="body-style">
       <xsl:attribute name="value">
        <!-- CSS properties -->
        <!--                -->
        <xsl:variable name="VarCSSPropertiesAsXML">
         <xsl:call-template name="CSS-TranslateProjectProperties">
          <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
          <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
          <xsl:with-param name="ParamSplits" select="$ParamSplits" />
         </xsl:call-template>
        </xsl:variable>
        <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

        <xsl:call-template name="CSS-InlineProperties">
         <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
        </xsl:call-template>
       </xsl:attribute>
      </wwpage:Replacement>

      <xsl:if test="string-length($VarPDFLinkURI) &gt; 0">
       <wwpage:Replacement name="pdf-link" value="{$VarPDFLinkURI}" />
      </xsl:if>

      <wwpage:Replacement name="pdf-target" value="{wwprojext:GetFormatSetting('pdf-target')}" />

      <wwpage:Replacement name="skip-navigation-uri" value="{$VarSkipNavigationURI}" />
      <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />
      <wwpage:Replacement name="navigation-previous-title" value="{$VarPreviousSplit/@title}" />
      <wwpage:Replacement name="navigation-next-title" value="{$VarNextSplit/@title}" />
      <wwpage:Replacement name="navigation-pdf-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'PDF']/@value}" />
      <wwpage:Replacement name="navigation-toc-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'TOCTabLabel']/@value}" />
      <wwpage:Replacement name="navigation-index-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'IXTabLabel']/@value}" />
      <wwpage:Replacement name="navigation-search-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'SearchTabLabel']/@value}" />

      <wwpage:Replacement name="catalog-css">
       <xsl:attribute name="value">
        <xsl:for-each select="$GlobalFiles[1]">
         <xsl:variable name="VarCSSPath" select="key('wwfiles-files-by-documentid', $ParamFilesDocumentNode/@documentID)[@type = $ParameterStylesType]/@path" />
         <xsl:value-of select="wwuri:GetRelativeTo($VarCSSPath, $ParamSplit/@path)" />
        </xsl:for-each>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="document-css">
       <xsl:attribute name="value">
        <xsl:call-template name="URI-ResolveProjectFileURI">
         <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
         <xsl:with-param name="ParamSplits" select="$ParamSplits" />
         <xsl:with-param name="ParamURI" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value" />
        </xsl:call-template>
       </xsl:attribute>
      </wwpage:Replacement>

      <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
      <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

      <wwpage:Replacement name="google-analytics">
       <xsl:text>var _gaq = _gaq || [];
_gaq.push(['_setAccount', '</xsl:text>
       <xsl:value-of select="wwprojext:GetFormatSetting('google-analytics-id')" />
      <xsl:text>']);
_gaq.push(['_trackPageview']);

(function() {
  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
  var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
})();</xsl:text>
      </wwpage:Replacement>

      <xsl:if test="count($VarPreviousSplit) = 1">
       <wwpage:Replacement name="navigation-previous-link" value="{wwuri:GetRelativeTo($VarPreviousSplit/@path, $ParamSplit/@path)}" />
      </xsl:if>
      <xsl:if test="count($VarNextSplit) = 1">
       <wwpage:Replacement name="navigation-next-link" value="{wwuri:GetRelativeTo($VarNextSplit/@path, $ParamSplit/@path)}" />
      </xsl:if>

      <!-- Company Info -->
      <!--              -->
      <xsl:call-template name="CompanyInfo-Replacements">
       <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
       <xsl:with-param name="ParamPagePath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      </xsl:call-template>

      <!-- Breadcrumbs -->
      <!--             -->
      <wwpage:Replacement name="breadcrumbs">
       <xsl:copy-of select="$VarBreadcrumbs" />
      </wwpage:Replacement>

      <!-- Content -->
      <!--         -->
      <wwpage:Replacement name="content">
       <xsl:call-template name="Content-Content">
        <xsl:with-param name="ParamContent" select="$ParamContent" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
       <xsl:call-template name="Content-Notes">
        <xsl:with-param name="ParamNotes" select="$VarNotes" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
        <xsl:with-param name="ParamCargo" select="$VarCargo" />
        <xsl:with-param name="ParamLinks" select="$ParamLinks" />
        <xsl:with-param name="ParamTOCData" select="$ParamTOCData" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
      </wwpage:Replacement>

      <!-- Publication Date. -Lief 3. May 2011 -->
      <!--                   -->
      <!-- <wwpage:Replacement name="pub-date"> -->
      <!--   <html:div>Updated: date</html:div> -->
      <!-- </wwpage:Replacement> -->

      <wwpage:Replacement name="pub-date">
        <html:div>Updated: <xsl:value-of select="wwdatetime:TicksAsRFC1123(wwdatetime:NowAsTicks())" /></html:div>
      </wwpage:Replacement>


      <!-- Variables -->
      <!--           -->
      <xsl:variable name="VarSplitGlobalVariablesAsXML">
       <xsl:call-template name="Variables-Globals-Split">
        <xsl:with-param name="ParamProjectVariables" select="$GlobalProjectVariables" />
        <xsl:with-param name="ParamSplit" select="$ParamSplit" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarSplitGlobalVariables" select="msxsl:node-set($VarSplitGlobalVariablesAsXML)/wwvars:Variable" />
      <xsl:call-template name="Variables-Page-String-Replacements">
       <xsl:with-param name="ParamVariables" select="$VarSplitGlobalVariables" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

     <!-- Map common characters -->
     <!--                       -->
     <wwexsldoc:MappingContext>
      <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

      <!-- Invoke page template -->
      <!--                      -->
      <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
       <xsl:with-param name="ParamPageTemplateURI" select="$ParameterPageTemplateURI" />
       <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
       <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamConditions" select="$VarConditions" />
       <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
      </xsl:apply-templates>
     </wwexsldoc:MappingContext>
    </xsl:for-each>
   </xsl:variable>

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
    <xsl:variable name="VarPrettyPrint">
     <xsl:choose>
      <xsl:when test="wwprojext:GetFormatSetting('file-processing-pretty-print') = 'true'">
       <xsl:text>yes</xsl:text>
      </xsl:when>

      <xsl:otherwise>
       <xsl:text>no</xsl:text>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $ParamSplit/@path, wwprojext:GetFormatSetting('encoding', 'utf-8'), 'html', '5.0', $VarPrettyPrint, 'yes', 'no', 'urn:WebWorks_DOCTYPE_ElementOnly', '')" />
   </xsl:if>
  </xsl:if>

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <!-- Record files -->
   <!--              -->
   <wwfiles:File path="{$ParamSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($ParamSplit/@path)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$ParamSplit/@groupID}" documentID="{$ParamSplit/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$ParamFilesDocumentNode/@path}" checksum="{$ParamFilesDocumentNode/@checksum}" groupID="{$ParamFilesDocumentNode/@groupID}" documentID="{$ParamFilesDocumentNode/@documentID}" />
    <wwfiles:Depends path="{$ParamFilesSplits/@path}" checksum="{$ParamFilesSplits/@checksum}" groupID="{$ParamFilesSplits/@groupID}" documentID="{$ParamFilesSplits/@documentID}" />
    <wwfiles:Depends path="{$ParamBehaviorsFile/@path}" checksum="{$ParamBehaviorsFile/@checksum}" groupID="{$ParamBehaviorsFile/@groupID}" documentID="{$ParamBehaviorsFile/@documentID}" />

    <!-- Page Template Include Files -->
    <!--                             -->
    <xsl:for-each select="$GlobalPageTemplateIncludeFiles">
     <xsl:variable name="VarFile" select="." />

     <wwfiles:Depends path="{$VarFile/@path}" checksum="{wwfilesystem:GetChecksum($VarFile/@path)}" groupID="" documentID="" />
    </xsl:for-each>
   </wwfiles:File>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
